/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class ArgumentHandler {
    private String[] args;
    private OptionSet optionSet;
    private OptionSpec<String> profileOption;
    private OptionSpec<File> gameDirOption;
    private OptionSpec<File> assetsDirOption;
    private OptionSpec<File> minecraftJarOption;
    private OptionSpec<String> nonOption;
    private OptionSpec<String> launchTarget;

    void setArgs(String[] args) {
        this.args = args;
    }

    void processArguments(Environment env, Consumer<OptionParser> parserConsumer, BiConsumer<OptionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult>> resultConsumer) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        this.profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        this.gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().ofType(File.class);
        this.assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().ofType(File.class);
        this.minecraftJarOption = parser.accepts("minecraftJar", "Path to minecraft jar").withRequiredArg().ofType(File.class).withValuesSeparatedBy(',');
        this.launchTarget = parser.accepts("launchTarget", "LauncherService target to launch").withRequiredArg();
        parserConsumer.accept(parser);
        this.nonOption = parser.nonOptions();
        this.optionSet = parser.parse(this.args);
        env.getAll().computeIfAbsent(IEnvironment.Keys.VERSION.get(), s -> (String)this.optionSet.valueOf(this.profileOption));
        env.getAll().computeIfAbsent(IEnvironment.Keys.GAMEDIR.get(), f -> (File)this.optionSet.valueOf(this.gameDirOption));
        env.getAll().computeIfAbsent(IEnvironment.Keys.ASSETSDIR.get(), f -> (File)this.optionSet.valueOf(this.assetsDirOption));
        resultConsumer.accept(this.optionSet, this::optionResults);
    }

    File[] getSpecialJars() {
        return this.optionSet.valuesOf(this.minecraftJarOption).toArray(new File[0]);
    }

    String getLaunchTarget() {
        return (String)this.optionSet.valueOf(this.launchTarget);
    }

    private ITransformationService.OptionResult optionResults(final String serviceName, final OptionSet set) {
        return new ITransformationService.OptionResult(){

            @Override
            @Nonnull
            public <V> V value(OptionSpec<V> option) {
                this.checkOwnership(option);
                return (V)set.valueOf(option);
            }

            @Override
            @Nonnull
            public <V> List<V> values(OptionSpec<V> option) {
                this.checkOwnership(option);
                return set.valuesOf(option);
            }

            private <V> void checkOwnership(OptionSpec<V> option) {
                if (!option.options().stream().allMatch(opt -> opt.startsWith(serviceName + ".") || !opt.contains("."))) {
                    throw new IllegalArgumentException("Cannot process non-arguments");
                }
            }
        };
    }

    public String[] buildArgumentList() {
        String[] ret = new String[this.args.length];
        System.arraycopy(this.args, 0, ret, 0, this.args.length);
        return ret;
    }
}

