/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.InventorySorter;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyHandler {
    @SubscribeEvent
    public void onKey(GuiScreenEvent.MouseInputEvent.Pre evt) {
        Action action = Action.interpret(new KeyStates());
        if (action != null && evt.gui instanceof GuiContainer && !(evt.gui instanceof GuiContainerCreative)) {
            Slot slot = ((GuiContainer)evt.gui).getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            InventorySorter.INSTANCE.log.log(Level.DEBUG, "Sending action {} slot {}", new Object[]{action, slot.field_75222_d});
            InventorySorter.INSTANCE.channel.sendToServer((IMessage)action.message(slot));
            evt.setCanceled(true);
        }
    }

    static class KeyStates {
        private final boolean leftMouse = Mouse.getEventButton() == 0;
        private final boolean middleMouse = Mouse.getEventButton() == 2;
        private final boolean rightMouse = Mouse.getEventButton() == 1;
        private final boolean shiftDown;
        private final boolean ctrlDown;
        private final boolean altDown;
        private final boolean space;
        private final int mouseWheel;
        private final boolean isDownClick = Mouse.getEventButtonState();

        KeyStates() {
            this.shiftDown = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            this.ctrlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            this.altDown = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
            this.space = Keyboard.isKeyDown((int)57);
            this.mouseWheel = Mouse.getEventDWheel();
        }

        public boolean isLeftMouse() {
            return this.leftMouse;
        }

        public boolean isMiddleMouse() {
            return this.middleMouse;
        }

        public boolean isRightMouse() {
            return this.rightMouse;
        }

        public boolean isShiftDown() {
            return this.shiftDown;
        }

        public boolean isCtrlDown() {
            return this.ctrlDown;
        }

        public boolean isAltDown() {
            return this.altDown;
        }

        public boolean isSpace() {
            return this.space;
        }

        public int getMouseWheel() {
            return this.mouseWheel;
        }

        public boolean mouseWheelRollingUp() {
            return this.mouseWheel > 0;
        }

        public boolean mouseWheelRollingDown() {
            return this.mouseWheel < 0;
        }

        public boolean isDownClick() {
            return this.isDownClick;
        }
    }
}

