/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Objects;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum InventoryHandler {
    INSTANCE;

    public final Method mergeStack = this.getMergeStackMethod();

    private Method getMergeStackMethod() {
        try {
            Method m = ReflectionHelper.findMethod(Container.class, null, (String[])new String[]{"func_75135_a", "mergeItemStack"}, (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean mergeStack(Container container, ItemStack stack, int low, int high, boolean rev) {
        try {
            return (Boolean)this.mergeStack.invoke((Object)container, stack, low, high, rev);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getItemStack(Action.ActionContext ctx) {
        return this.getItemStack(ctx.slot);
    }

    public ItemStack getItemStack(Slot slot) {
        return slot.field_75224_c.func_70301_a(slot.getSlotIndex());
    }

    public void moveItemToOtherInventory(Slot origin, Action.ActionContext ctx, Map<IInventory, InventoryMapping> mapping, ItemStack is, boolean rev) {
        int targetLow = 0;
        int targetHigh = 0;
        boolean forcedSlot = false;
        if (!rev && ctx.slot.func_75211_c().func_77976_d() > ctx.slot.func_75211_c().field_77994_a) {
            targetLow = ctx.slot.field_75222_d;
            targetHigh = ctx.slot.field_75222_d + 1;
            forcedSlot = true;
        }
        if (ctx.player.field_71069_bz == ctx.player.field_71070_bA && !forcedSlot) {
            boolean sourceHotBar = origin.field_75222_d >= 36 && origin.field_75222_d < 45;
            targetLow = sourceHotBar ? 9 : 36;
            targetHigh = sourceHotBar ? 36 : 45;
        } else if (origin.field_75224_c == ctx.player.field_71071_by && !forcedSlot) {
            for (Map.Entry<IInventory, InventoryMapping> m : mapping.entrySet()) {
                if (m.getKey() == ctx.player.field_71071_by) continue;
                targetLow = m.getValue().begin;
                targetHigh = m.getValue().end;
            }
        } else if (!forcedSlot) {
            InventoryMapping m = mapping.get(ctx.player.field_71071_by);
            targetLow = m.begin;
            targetHigh = m.end;
        }
        int rng = targetHigh - targetLow;
        for (int i = 0; i < rng; ++i) {
            int slNum;
            int n = slNum = rev ? targetHigh - i - 1 : targetLow + i;
            if (ctx.player.field_71070_bA.func_75139_a(slNum).func_75214_a(is) && this.mergeStack(ctx.player.field_71070_bA, is, slNum, slNum + 1, !rev)) break;
        }
    }

    public Slot findStackWithItem(ItemStack is, Action.ActionContext ctx, Map<IInventory, InventoryMapping> mapping, Slot origin) {
        if (is.func_77976_d() == 1) {
            return null;
        }
        if (ctx.player.field_71069_bz == ctx.player.field_71070_bA) {
            boolean sourceHotBar = origin.getSlotIndex() < 9;
            int searchLow = sourceHotBar ? 9 : 36;
            int searchHigh = sourceHotBar ? 36 : 45;
            for (int i = searchLow; i < searchHigh; ++i) {
                ItemStack sis = ctx.player.field_71069_bz.func_75139_a(i).func_75211_c();
                if (sis == null || sis.func_77973_b() != is.func_77973_b() || !ItemStack.func_77970_a((ItemStack)sis, (ItemStack)is)) continue;
                return ctx.player.field_71070_bA.func_75139_a(i);
            }
            return null;
        }
        for (Map.Entry ent : ctx.mapping.entrySet()) {
            IInventory inv = (IInventory)ent.getKey();
            if (inv == origin.field_75224_c) continue;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack sis;
                if (inv.func_70301_a(i) == null || (sis = inv.func_70301_a(i)).func_77973_b() != is.func_77973_b() || !ItemStack.func_77970_a((ItemStack)sis, (ItemStack)is)) continue;
                return ctx.player.field_71070_bA.func_75147_a(inv, i);
            }
        }
        return null;
    }

    public Multiset<ItemStackHolder> getInventoryContent(Action.ActionContext context) {
        int slotHigh;
        int slotLow;
        if (context.slot.field_75224_c == context.player.field_71071_by) {
            boolean isPlayerContainer = context.player.field_71070_bA == context.player.field_71069_bz;
            boolean sourceHotBar = context.slot.getSlotIndex() < 9;
            int offset = isPlayerContainer ? 4 : 0;
            InventoryMapping m = (InventoryMapping)context.mapping.get((Object)context.player.field_71071_by);
            slotLow = sourceHotBar ? m.end - 8 : m.begin + offset;
            slotHigh = sourceHotBar ? m.end + 1 : m.end - 8;
        } else {
            InventoryMapping m = (InventoryMapping)context.mapping.get((Object)context.slot.field_75224_c);
            slotLow = m.begin;
            slotHigh = m.end + 1;
        }
        TreeMultiset itemcounts = TreeMultiset.create((Comparator)new ItemStackComparator());
        for (int i = slotLow; i < slotHigh; ++i) {
            ItemStack stack;
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            if (!slot.func_82869_a((EntityPlayer)context.player) || (stack = slot.func_75211_c()) == null || stack.func_77973_b() == null) continue;
            ItemStackHolder ish = new ItemStackHolder(stack.func_77946_l());
            itemcounts.add((Object)ish, stack.field_77994_a);
        }
        return itemcounts;
    }

    public static class InventoryMapping {
        int begin = Integer.MAX_VALUE;
        int end = 0;
        final IInventory inv;
        final Container container;

        InventoryMapping(IInventory inv, Container container) {
            this.inv = inv;
            this.container = container;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("i", (Object)this.inv).add("c", (Object)this.container).add("b", this.begin).add("e", this.end).toString();
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStackHolder> {
        @Override
        public int compare(ItemStackHolder o1, ItemStackHolder o2) {
            if (o1.is.func_77973_b() != o2.is.func_77973_b()) {
                return o1.is.func_77973_b().getRegistryName().compareTo(o2.is.func_77973_b().getRegistryName());
            }
            if (o1.is.func_77960_j() != o2.is.func_77960_j()) {
                return Ints.compare((int)o1.is.func_77960_j(), (int)o2.is.func_77960_j());
            }
            if (ItemStack.func_77970_a((ItemStack)o1.is, (ItemStack)o2.is)) {
                return 0;
            }
            return -1;
        }
    }
}

