/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.inventorysorter.AllItemsHandler;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public enum Action {
    SORT(SortingHandler.INSTANCE),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT),
    ALL(AllItemsHandler.INSTANCE);

    private final Function<ActionContext, Void> worker;

    private Action(Function<ActionContext, Void> worker) {
        this.worker = worker;
    }

    public static Action interpret(KeyHandler.KeyStates keyStates) {
        if (keyStates.isDownClick()) {
            return null;
        }
        if (keyStates.isMiddleMouse()) {
            return SORT;
        }
        if (keyStates.mouseWheelRollingDown()) {
            return ONEITEMIN;
        }
        if (keyStates.mouseWheelRollingUp()) {
            return ONEITEMOUT;
        }
        if (keyStates.isSpace()) {
            return ALL;
        }
        return null;
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.field_75222_d);
    }

    public void execute(ActionContext context) {
        this.worker.apply((Object)context);
    }

    public static class ActionContext {
        public final Slot slot;
        public final EntityPlayerMP player;
        public final ImmutableMap<IInventory, InventoryHandler.InventoryMapping> mapping;

        public ActionContext(Slot slot, EntityPlayerMP playerEntity) {
            this.slot = slot;
            this.player = playerEntity;
            HashMap mapping = Maps.newHashMap();
            for (Slot sl : playerEntity.field_71070_bA.field_75151_b) {
                if (!mapping.containsKey(sl.field_75224_c)) {
                    mapping.put(sl.field_75224_c, new InventoryHandler.InventoryMapping(sl.field_75224_c, playerEntity.field_71070_bA));
                }
                ((InventoryHandler.InventoryMapping)mapping.get((Object)sl.field_75224_c)).begin = Math.min(sl.field_75222_d, ((InventoryHandler.InventoryMapping)mapping.get((Object)sl.field_75224_c)).begin);
                ((InventoryHandler.InventoryMapping)mapping.get((Object)sl.field_75224_c)).end = Math.max(sl.field_75222_d, ((InventoryHandler.InventoryMapping)mapping.get((Object)sl.field_75224_c)).end);
            }
            this.mapping = ImmutableMap.copyOf((Map)mapping);
        }
    }
}

