/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

public class Murmur2 {
    private static final int M_32 = 1540483477;
    private static final int R_32 = 24;
    private static final long M_64 = -4132994306676758123L;
    private static final int R_64 = 47;
    private static final int DEFAULT_SEED = 0;

    public static int hash32(byte[] data) {
        return Murmur2.hash32(data, data.length, 0);
    }

    public static int hash32(byte[] data, int length, int seed) {
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4] & 0xFF | (data[i_4 + 1] & 0xFF) << 8 | (data[i_4 + 2] & 0xFF) << 16 | (data[i_4 + 3] & 0xFF) << 24;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= 1540483477;
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static long hash64(byte[] data) {
        return Murmur2.hash64(data, data.length, 0);
    }

    public static long hash64(byte[] data, int length, int seed) {
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length >> 3;
        for (int i = 0; i < length8; ++i) {
            int i8 = i << 3;
            long k = (long)data[i8] & 0xFFL | ((long)data[i8 + 1] & 0xFFL) << 8 | ((long)data[i8 + 2] & 0xFFL) << 16 | ((long)data[i8 + 3] & 0xFFL) << 24 | ((long)data[i8 + 4] & 0xFFL) << 32 | ((long)data[i8 + 5] & 0xFFL) << 40 | ((long)data[i8 + 6] & 0xFFL) << 48 | ((long)data[i8 + 7] & 0xFFL) << 56;
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        int tailStart = length8 << 3;
        switch (length - tailStart) {
            case 7: {
                h ^= (long)(data[tailStart + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(data[tailStart + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(data[tailStart + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(data[tailStart + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(data[tailStart + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(data[tailStart + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(data[tailStart] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }
}

