/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import com.google.gson.JsonObject;
import cpw.mods.forge.cursepacklocator.FileCacheManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackFile {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String projectId;
    private final String fileId;
    private final Consumer<String> progressUpdater;
    private String fileName;

    public PackFile(String projectId, String fileId, Consumer<String> progressUpdater) {
        this.projectId = projectId;
        this.fileId = fileId;
        this.progressUpdater = progressUpdater;
    }

    public void loadFileIntoPlace(Path targetPackDir, FileCacheManager fileCacheManager) {
        LOGGER.info("CursePackDownloader is loading file {} - {}", (Object)this.projectId, (Object)this.fileId);
        Path path = fileCacheManager.downloadFile(this.projectId, this.fileId);
        JsonObject info = fileCacheManager.downloadInfo(this.projectId, this.fileId);
        this.fileName = info.get("fileName").getAsString();
        Path targetFile = targetPackDir.resolve(this.fileName);
        if (Files.exists(targetFile, new LinkOption[0]) && fileCacheManager.validateFile(targetFile, info.get("packageFingerprint").getAsLong())) {
            LOGGER.info("Skipping existing file {}", (Object)this.fileName);
            return;
        }
        try {
            Files.copy(path, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LOGGER.info("CursePackDownloader has loaded file {} - {} ({})", (Object)this.projectId, (Object)this.fileId, (Object)this.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }
}

