/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import cpw.mods.forge.cursepacklocator.Murmur2;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class HashChecker {
    private static byte[] computeNormalizedArray(byte[] input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (byte b : input) {
            if (b == 9 || b == 10 || b == 13 || b == 32) continue;
            bos.write(b);
        }
        return bos.toByteArray();
    }

    public static long computeHash(Path file) {
        try {
            byte[] bytes = Files.readAllBytes(file);
            byte[] normalizedArray = HashChecker.computeNormalizedArray(bytes);
            int res = Murmur2.hash32(normalizedArray, normalizedArray.length, 1);
            return Integer.toUnsignedLong(res);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

