/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import cpw.mods.forge.cursepacklocator.DirHandler;
import cpw.mods.forge.cursepacklocator.HashChecker;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileCacheManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INFOURL = "https://addons-ecs.forgesvc.net/api/v2/addon/%s/file/%s";
    private final Path infos;
    private final Path files;
    private Consumer<String> progressUpdater;

    FileCacheManager() {
        this(Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.ASSETSDIR.get()).orElseGet(() -> DirHandler.createOrGetDirectory(Paths.get(".", new String[0]), "cursecache")));
    }

    public FileCacheManager(Path assetsDir) {
        Path cheesycursecache = DirHandler.createOrGetDirectory(assetsDir, "cheesycursecache");
        this.infos = DirHandler.createOrGetDirectory(cheesycursecache, "infos");
        this.files = DirHandler.createOrGetDirectory(cheesycursecache, "files");
    }

    public Optional<JsonObject> loadInfo(String projectId, String fileId) {
        Path infoPath = this.resolveInfo(projectId, fileId);
        if (!Files.exists(infoPath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(FileCacheManager.loadJsonFromFile(infoPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject loadJsonFromFile(Path infoPath) {
        try (JsonReader jsonReader = new Gson().newJsonReader((Reader)Files.newBufferedReader(infoPath));){
            JsonObject jsonObject = new JsonParser().parse(jsonReader).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path resolveInfo(String projectId, String fileId) {
        return this.infos.resolve(projectId + "-" + fileId + ".json");
    }

    private Path resolveFile(String projectId, String fileId) {
        return this.files.resolve(projectId + "-" + fileId + ".jar");
    }

    private Optional<Path> loadFile(String projectId, String fileId) {
        Path filePath = this.resolveFile(projectId, fileId);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(filePath);
    }

    public Path downloadFile(String projectId, String fileId) {
        JsonObject fileInfo = this.downloadInfo(projectId, fileId);
        long packageFingerprint = fileInfo.get("packageFingerprint").getAsLong();
        Path downloadedFile = this.loadFile(projectId, fileId).filter(file -> this.validateFile((Path)file, packageFingerprint)).orElseGet(() -> this.fetchFile(fileInfo.get("downloadUrl").getAsString(), projectId, fileId));
        if (!this.validateFile(downloadedFile, packageFingerprint)) {
            throw new RuntimeException("Unable to validate the downloaded file " + projectId + " - " + fileId);
        }
        return downloadedFile;
    }

    private Path fetchFile(String downloadUrl, String projectId, String fileId) {
        Path downloadTo = this.resolveFile(projectId, fileId);
        String fname = downloadUrl.substring(downloadUrl.lastIndexOf(47) + 1);
        String rest = downloadUrl.substring(0, downloadUrl.lastIndexOf(47));
        String encname = fname;
        try {
            encname = URLEncoder.encode(fname, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        encname = encname.replaceAll("\\+", "%20");
        return this.downloadToFile(downloadTo, rest + "/" + encname);
    }

    boolean validateFile(Path file, long checksum) {
        return HashChecker.computeHash(file) == checksum;
    }

    public JsonObject downloadInfo(String projectId, String fileId) {
        return this.loadInfo(projectId, fileId).orElseGet(() -> this.fetchInfo(projectId, fileId));
    }

    private JsonObject fetchInfo(String projectId, String fileId) {
        Path path = this.downloadToFile(this.resolveInfo(projectId, fileId), String.format(INFOURL, projectId, fileId));
        return FileCacheManager.loadJsonFromFile(path);
    }

    private Path downloadToFile(Path target, String urlToGet) {
        try {
            this.progressUpdater.accept("Downloading file " + target.getFileName().toString());
            URL url = new URL(urlToGet);
            LOGGER.info("Downloading from URL {}", (Object)urlToGet);
            Files.copy(url.openStream(), target, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Downloaded from URL {}", (Object)urlToGet);
            return target;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void setProgressUpdater(Consumer<String> progressUpdater) {
        this.progressUpdater = progressUpdater;
    }
}

