/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class DirHandler {
    public static Path createOrGetDirectory(Path root, String name) {
        Path newDir = root.resolve(name);
        if (Files.exists(newDir, new LinkOption[0]) && Files.isDirectory(newDir, new LinkOption[0])) {
            return newDir;
        }
        try {
            Files.createDirectory(newDir, new FileAttribute[0]);
            return newDir;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static Path createDirIfNeeded(Path file) {
        try {
            Files.createDirectories(file, new FileAttribute[0]);
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

