/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import cpw.mods.forge.cursepacklocator.DirHandler;
import cpw.mods.forge.cursepacklocator.FileCacheManager;
import cpw.mods.forge.cursepacklocator.PackFile;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CursePack {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path gameDir;
    private final JsonObject manifest;
    private final FileCacheManager fileCacheManager;
    private boolean validPack;
    private CompletableFuture<Void> packDownload;
    private Path curseModDir;
    private List<String> fileNames = new ArrayList<String>();
    private Set<String> excludedProjectIds = new HashSet<String>();
    private Set<String> excludedFileIds = new HashSet<String>();
    private Consumer<String> progressUpdater;

    public CursePack(Path gameDir, FileCacheManager fileCacheManager) {
        this.fileCacheManager = fileCacheManager;
        JsonObject manifest1 = null;
        this.gameDir = gameDir;
        if (!Files.exists(gameDir.resolve("manifest.json"), new LinkOption[0])) {
            LOGGER.info("No manifest.json file found, skipping");
        } else {
            try (JsonReader jsonReader = new Gson().newJsonReader((Reader)Files.newBufferedReader(gameDir.resolve("manifest.json")));){
                manifest1 = new JsonParser().parse(jsonReader).getAsJsonObject();
                this.curseModDir = DirHandler.createOrGetDirectory(gameDir, "cursemods");
                this.validPack = true;
            }
            catch (IOException e) {
                LOGGER.info("Error trying to load manifest.json", (Throwable)e);
            }
        }
        this.manifest = manifest1;
        Path exclusions = gameDir.resolve("exclusions.json");
        if (Files.exists(exclusions, new LinkOption[0])) {
            JsonObject jsonObject = FileCacheManager.loadJsonFromFile(exclusions);
            StreamSupport.stream(jsonObject.getAsJsonArray("excludedProjectIds").spliterator(), false).map(JsonElement::getAsString).forEach(this.excludedProjectIds::add);
            StreamSupport.stream(jsonObject.getAsJsonArray("excludedFileIds").spliterator(), false).map(JsonElement::getAsString).forEach(this.excludedFileIds::add);
        }
    }

    public boolean isValidPack() {
        return this.validPack;
    }

    public void startPackDownload(Consumer<String> progressUpdater) {
        this.progressUpdater = progressUpdater;
        JsonArray files = this.manifest.getAsJsonArray("files");
        progressUpdater.accept("Retrieving files for curseforge pack " + this.manifest.get("name").getAsString());
        LOGGER.info("Found {} files in pack to consider", (Object)files.size());
        progressUpdater.accept("Found " + files.size() + " files in pack");
        ExecutorService executorService = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("cpd.maxThreads", String.valueOf(Runtime.getRuntime().availableProcessors()))));
        CompletableFuture<List<String>> result = CompletableFuture.completedFuture(Collections.synchronizedList(this.fileNames));
        this.packDownload = ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])StreamSupport.stream(files.spliterator(), false).map(JsonElement::getAsJsonObject).filter(file -> !this.excludedProjectIds.contains(file.get("projectID").getAsString()) && !this.excludedFileIds.contains(file.get("fileID").getAsString())).map(file -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.fetchFile((JsonObject)file), executorService).thenApply(PackFile::getFileName)).thenCombine(result, (packFile, res) -> res.add(packFile))).toArray(CompletableFuture[]::new)).thenRun(executorService::shutdown)).thenRun(this::extractOverrides)).whenComplete(this::finished);
    }

    private void extractOverrides() {
        Path overridePath = this.gameDir.resolve("overrides");
        try (Stream<Path> overrides = Files.walk(overridePath, new FileVisitOption[0]);){
            overrides.forEach(path -> this.copyFile((Path)path, overridePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void copyFile(Path path, Path rootPath) {
        Path relative = rootPath.relativize(path);
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirHandler.createDirIfNeeded(this.gameDir.resolve(relative));
        } else {
            Path target = this.gameDir.resolve(relative);
            try {
                Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void finished(Void voivod, Throwable throwable) {
        if (throwable != null) {
            this.validPack = false;
            LOGGER.catching(throwable);
        } else {
            LOGGER.info("Successfully fetched {} files", (Object)this.fileNames.size());
        }
    }

    private PackFile fetchFile(JsonObject file) {
        String projectID = file.get("projectID").getAsString();
        String fileID = file.get("fileID").getAsString();
        PackFile packFile = new PackFile(projectID, fileID, this.progressUpdater);
        packFile.loadFileIntoPlace(this.getCurseModPath(), this.fileCacheManager);
        return packFile;
    }

    public void waitForPackDownload() {
        try {
            this.packDownload.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getCurseModPath() {
        return this.curseModDir;
    }

    public boolean fileInPack(IModFile modFile) {
        return this.fileNames.contains(modFile.getFileName());
    }
}

