/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.forge.cursepacklocator;

import cpw.mods.forge.cursepacklocator.CursePack;
import cpw.mods.forge.cursepacklocator.DirHandler;
import cpw.mods.forge.cursepacklocator.FileCacheManager;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;

public class CurseLocator
implements IModLocator {
    private final FileCacheManager fileCacheManager;
    private IModLocator wrappedModFolderLocator;
    private final CursePack pack;

    public CurseLocator() {
        Path gameDir = (Path)Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseThrow(() -> new IllegalStateException("MISSING GAMEDIR?!"));
        this.fileCacheManager = new FileCacheManager();
        this.pack = new CursePack(gameDir, this.fileCacheManager);
    }

    public CurseLocator(Path dir) throws IOException {
        this.fileCacheManager = new FileCacheManager(DirHandler.createOrGetDirectory(dir, "dummycache"));
        this.pack = new CursePack(dir, this.fileCacheManager);
    }

    public List<IModFile> scanMods() {
        if (!this.pack.isValidPack()) {
            return Collections.emptyList();
        }
        this.pack.waitForPackDownload();
        List modFiles = this.wrappedModFolderLocator.scanMods();
        return modFiles.stream().filter(this.pack::fileInPack).collect(Collectors.toList());
    }

    public String name() {
        return "cursepack downloader";
    }

    public Path findPath(IModFile modFile, String ... path) {
        return this.wrappedModFolderLocator.findPath(modFile, path);
    }

    public void scanFile(IModFile modFile, Consumer<Path> pathConsumer) {
        this.wrappedModFolderLocator.scanFile(modFile, pathConsumer);
    }

    public Optional<Manifest> findManifest(Path file) {
        return this.wrappedModFolderLocator.findManifest(file);
    }

    public void initArguments(Map<String, ?> arguments) {
        if (!this.pack.isValidPack()) {
            return;
        }
        Function modFolderLocatorFactory = (Function)Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)Environment.Keys.MODFOLDERFACTORY.get()).orElseThrow(() -> new RuntimeException("Unable to locate ModsFolder locator factory"));
        Consumer progressUpdater = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get()).orElseGet(() -> s -> {});
        this.fileCacheManager.setProgressUpdater(progressUpdater);
        Path cursemods = this.pack.getCurseModPath();
        this.wrappedModFolderLocator = (IModLocator)modFolderLocatorFactory.apply(cursemods);
        this.pack.startPackDownload(progressUpdater);
    }

    public boolean isValid(IModFile modFile) {
        return this.wrappedModFolderLocator.isValid(modFile);
    }
}

