/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.bootstraplauncher;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BootstrapLauncher {
    public static void main(String[] args) throws URISyntaxException {
        String legacyCP = Objects.requireNonNull(System.getProperty("legacyClassPath"), "Missing legacyClassPath, cannot bootstrap");
        String versionName = Objects.requireNonNull(System.getProperty("versionName"), "Missing versionName, cannot bootstrap");
        List fileList = Arrays.stream(legacyCP.split(File.pathSeparator)).filter(n -> !n.endsWith(versionName + ".jar")).map(s -> URI.create("file://" + s)).collect(Collectors.toList());
        Collections.reverse(fileList);
        Stream<URL> urlList = fileList.stream().map(BootstrapLauncher.uncheck(URI::toURL));
        Stream<Path> pathList = fileList.stream().map(Path::of);
        JarModuleFinder jf = JarModuleFinder.of((SecureJar[])((SecureJar[])pathList.map(xva$0 -> SecureJar.from((Path[])new Path[]{xva$0})).toArray(SecureJar[]::new)));
        Configuration cf = ModuleLayer.boot().configuration();
        Configuration newcf = cf.resolveAndBind((ModuleFinder)jf, ModuleFinder.ofSystem(), List.of("cpw.mods.bootstraplauncher"));
        ModuleClassLoader mycl = new ModuleClassLoader("test", newcf, ModuleLayer.boot().findLoader("cpw.mods.securejarhandler"));
        ModuleLayer.Controller layer = ModuleLayer.defineModules(newcf, List.of(ModuleLayer.boot()), m -> mycl);
        Thread.currentThread().setContextClassLoader((ClassLoader)mycl);
        ServiceLoader<Consumer> loader = ServiceLoader.load(layer.layer(), Consumer.class);
        loader.stream().findFirst().orElseThrow().get().accept(args);
    }

    public static <T, R, E extends Throwable> Function<T, R> uncheck(ExcFunction<T, R, E> f) {
        return i -> {
            try {
                return f.apply(i);
            }
            catch (Throwable e) {
                BootstrapLauncher.throwAsUnchecked(e);
                return null;
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Throwable exception) throws E {
        throw exception;
    }

    public static interface ExcFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }
}

