/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.accesstransformer;

import cpw.mods.accesstransformer.AccessTransformerEngine;
import cpw.mods.accesstransformer.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.stream.StreamSupport;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.apache.logging.log4j.core.config.Configurator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class TransformerProcessor {
    public static void main(String ... args) {
        Path atFilePath;
        Path outputJarPath;
        Path inputJarPath;
        OptionSet optionSet;
        Configurator.initialize((String)"", (String)"atlog4j2.xml");
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec inputJar = optionParser.accepts("inJar", "Input JAR file to apply transformation to").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING})).required();
        ArgumentAcceptingOptionSpec atFile = optionParser.accepts("atfile", "Access Transformer File").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING})).required();
        try {
            optionSet = optionParser.parse(args);
            inputJarPath = ((Path)inputJar.value(optionSet)).toAbsolutePath();
            String s = inputJarPath.getFileName().toString();
            outputJarPath = inputJarPath.resolveSibling(s.substring(0, s.length() - 4) + "-new.jar");
            atFilePath = ((Path)atFile.value(optionSet)).toAbsolutePath();
        }
        catch (Exception e) {
            Logging.log.error("Option Parsing Error", (Throwable)e);
            return;
        }
        Logging.log.info("Reading from {}", (Object)inputJarPath);
        Logging.log.info("Writing to {}", (Object)outputJarPath);
        Logging.log.info("Transform file {}", (Object)atFilePath);
        try {
            Files.deleteIfExists(outputJarPath);
        }
        catch (IOException e) {
            Logging.log.error("Deleting existing out JAR", (Throwable)e);
        }
        TransformerProcessor.processJar((ArgumentAcceptingOptionSpec<Path>)inputJar, (ArgumentAcceptingOptionSpec<Path>)atFile, optionSet, outputJarPath, atFilePath);
        Logging.log.info("Transforming JAR complete {}", (Object)outputJarPath);
    }

    private static void processJar(ArgumentAcceptingOptionSpec<Path> inputJar, ArgumentAcceptingOptionSpec<Path> atFile, OptionSet optionSet, Path outputJarPath, Path atFilePath) {
        AccessTransformerEngine.INSTANCE.addResource((Path)atFile.value(optionSet), "input");
        Logging.log.info("Loaded transformers {}", (Object)atFilePath);
        URI outJarURI = URI.create("jar:file:" + outputJarPath);
        try (FileSystem outJar = FileSystems.newFileSystem(outJarURI, new HashMap<String, String>(){
            {
                this.put("create", "true");
            }
        });){
            Path outRoot = StreamSupport.stream(outJar.getRootDirectories().spliterator(), false).findFirst().get();
            try (FileSystem jarFile = FileSystems.newFileSystem((Path)inputJar.value(optionSet), ClassLoader.getSystemClassLoader());){
                Files.walk(StreamSupport.stream(jarFile.getRootDirectories().spliterator(), false).findFirst().orElseThrow(() -> new IllegalArgumentException("The JAR has no root?!")), new FileVisitOption[0]).forEach(path -> {
                    Path outPath = outJar.getPath(path.toAbsolutePath().toString(), new String[0]);
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        try {
                            Files.createDirectory(outPath, new FileAttribute[0]);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (path.getNameCount() > 0 && path.getFileName().toString().endsWith(".class")) {
                        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                            ClassReader classReader = new ClassReader(is);
                            ClassNode cn = new ClassNode();
                            classReader.accept((ClassVisitor)cn, 0);
                            Type type = Type.getType((String)('L' + cn.name.replaceAll("\\.", "/") + ';'));
                            if (AccessTransformerEngine.INSTANCE.handlesClass(type)) {
                                Logging.log.debug("Transforming class {}", (Object)type);
                                AccessTransformerEngine.INSTANCE.transform(cn, type);
                                ClassWriter cw = new ClassWriter(327680);
                                cn.accept((ClassVisitor)cw);
                                Files.write(outPath, cw.toByteArray(), new OpenOption[0]);
                            } else {
                                Logging.log.debug("Skipping {}", (Object)type);
                                Files.copy(path, outPath, new CopyOption[0]);
                            }
                        }
                        catch (IOException e) {
                            Logging.log.error("Reading {}", path, (Object)e);
                        }
                    } else if (!Files.exists(outPath, new LinkOption[0])) {
                        try {
                            Files.copy(path, outPath, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            Logging.log.error("Copying {}", path, (Object)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                Logging.log.error("Reading JAR", (Throwable)e);
            }
        }
        catch (IOException e) {
            Logging.log.error("Writing JAR", (Throwable)e);
        }
    }
}

