/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.accesstransformer;

import cpw.mods.accesstransformer.Logging;
import cpw.mods.accesstransformer.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public class AccessTransformer {
    private final Target memberTarget;
    private final Modifier targetAccess;
    private final FinalState targetFinalState;
    private final List<String> origins = new ArrayList<String>(1);

    public AccessTransformer(Target target, Modifier modifier, FinalState finalState, String origin, int lineNumber) {
        this.memberTarget = target;
        this.targetAccess = modifier;
        this.targetFinalState = finalState;
        this.origins.add(origin + ":" + lineNumber);
    }

    public <T> Target<T> getTarget() {
        return this.memberTarget;
    }

    public AccessTransformer mergeStates(AccessTransformer at2, String resourceName) {
        Modifier newModifier = Modifier.values()[Math.min(this.targetAccess.ordinal(), at2.targetAccess.ordinal())];
        FinalState newFinalState = FinalState.values()[this.targetFinalState.ordinal() & at2.targetFinalState.ordinal()];
        AccessTransformer accessTransformer = new AccessTransformer(this.memberTarget, newModifier, newFinalState, resourceName + ":merge", 0);
        accessTransformer.origins.addAll(this.origins);
        accessTransformer.origins.addAll(at2.origins);
        return accessTransformer;
    }

    public boolean isValid() {
        return this.targetFinalState != FinalState.CONFLICT;
    }

    public List<String> getOrigins() {
        return this.origins;
    }

    public <T> void applyModifier(T node, Class<T> type, Set<String> privateChanged) {
        Logging.log.debug("Transforming {} to access {} and {}", this.getTarget(), (Object)this.targetAccess, (Object)this.targetFinalState);
        this.getTarget().apply(node, this.targetAccess, this.targetFinalState, privateChanged);
    }

    public String toString() {
        return Objects.toString(this.memberTarget) + " " + Objects.toString((Object)this.targetAccess) + " " + Objects.toString((Object)this.targetFinalState) + " " + Objects.toString(this.origins.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public static enum FinalState {
        LEAVE(i -> i),
        MAKEFINAL(i -> i | 0x10),
        REMOVEFINAL(i -> i & 0xFFFFFFEF),
        CONFLICT(i -> i);

        private IntFunction<Integer> function;

        private FinalState(IntFunction<Integer> function) {
            this.function = function;
        }

        public int mergeWith(int access) {
            return this.function.apply(access);
        }
    }

    public static enum Modifier {
        PUBLIC(1),
        PROTECTED(4),
        DEFAULT(0),
        PRIVATE(2);

        private final int accFlag;

        private Modifier(int accFlag) {
            this.accFlag = accFlag;
        }

        public int mergeWith(int access) {
            int previousAccess = access & 0xFFFFFFF8;
            return previousAccess | this.accFlag;
        }
    }
}

