/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.accesstransformer.parser;

import com.demonwav.primeiron.AtParser;
import com.demonwav.primeiron.AtParserBaseVisitor;
import cpw.mods.accesstransformer.AccessTransformer;
import cpw.mods.accesstransformer.ClassTarget;
import cpw.mods.accesstransformer.FieldTarget;
import cpw.mods.accesstransformer.MethodTarget;
import cpw.mods.accesstransformer.WildcardTarget;
import cpw.mods.accesstransformer.parser.ModifierProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;

public class AccessTransformVisitor
extends AtParserBaseVisitor<Void> {
    private List<AccessTransformer> accessTransformers = new ArrayList<AccessTransformer>();
    private final String origin;

    public AccessTransformVisitor(String origin) {
        this.origin = origin;
    }

    @Override
    public Void visitEntry(AtParser.EntryContext ctx) {
        if (ctx.line_value() == null) {
            String className = ctx.class_name().getText();
            String modifier = ctx.keyword().getText();
            ClassTarget target = new ClassTarget(className);
            this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        }
        return (Void)super.visitEntry(ctx);
    }

    @Override
    public Void visitFunction(AtParser.FunctionContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        String methodName = ctx.func_name().getText();
        List<String> args = ctx.argument().stream().map(RuleContext::getText).collect(Collectors.toList());
        String retVal = ctx.return_value().getText();
        MethodTarget target = new MethodTarget(className, methodName, args, retVal);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitFunction(ctx);
    }

    @Override
    public Void visitField_name(AtParser.Field_nameContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        String fieldName = ctx.getText();
        FieldTarget target = new FieldTarget(className, fieldName);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitField_name(ctx);
    }

    @Override
    public Void visitWildcard_field(AtParser.Wildcard_fieldContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        WildcardTarget target = new WildcardTarget(className, false);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitWildcard_field(ctx);
    }

    @Override
    public Void visitWildcard_method(AtParser.Wildcard_methodContext ctx) {
        AtParser.EntryContext entry = (AtParser.EntryContext)ctx.getParent().getParent();
        String className = entry.class_name().getText();
        String modifier = entry.keyword().getText();
        WildcardTarget target = new WildcardTarget(className, true);
        this.accessTransformers.add(new AccessTransformer(target, ModifierProcessor.modifier(modifier), ModifierProcessor.finalState(modifier), this.origin, ctx.getStart().getLine()));
        return (Void)super.visitWildcard_method(ctx);
    }

    public List<AccessTransformer> getAccessTransformers() {
        return this.accessTransformers;
    }
}

