/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.accesstransformer;

import cpw.mods.accesstransformer.AccessTransformer;
import cpw.mods.accesstransformer.TargetType;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.Type;

public abstract class Target<T> {
    private final String className;
    private Type type;

    public Target(String className) {
        this.className = className;
        this.type = Type.getType((String)("L" + className.replaceAll("\\.", "/") + ";"));
    }

    public TargetType getType() {
        return TargetType.CLASS;
    }

    public String getClassName() {
        return this.className;
    }

    public final Type getASMType() {
        return this.type;
    }

    public String toString() {
        return Objects.toString(this.className) + " " + Objects.toString((Object)this.getType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Target)) {
            return false;
        }
        return Objects.equals(this.className, ((Target)obj).className) && Objects.equals((Object)this.getType(), (Object)((Target)obj).getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), "CLASS"});
    }

    public abstract String targetName();

    public abstract void apply(T var1, AccessTransformer.Modifier var2, AccessTransformer.FinalState var3, Set<String> var4);
}

