/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.accesstransformer;

import cpw.mods.accesstransformer.AccessTransformer;
import cpw.mods.accesstransformer.Target;
import cpw.mods.accesstransformer.TargetType;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.tree.FieldNode;

public class FieldTarget
extends Target<FieldNode> {
    private final String fieldName;

    public FieldTarget(String className, String fieldName) {
        super(className);
        this.fieldName = fieldName;
    }

    @Override
    public TargetType getType() {
        return TargetType.FIELD;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Objects.toString(this.fieldName);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FieldTarget)) {
            return false;
        }
        return super.equals(obj) && Objects.equals(this.fieldName, ((FieldTarget)obj).fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), this.fieldName});
    }

    @Override
    public void apply(FieldNode node, AccessTransformer.Modifier targetAccess, AccessTransformer.FinalState targetFinalState, Set<String> privateChanged) {
        node.access = targetAccess.mergeWith(node.access);
        node.access = targetFinalState.mergeWith(node.access);
    }

    @Override
    public String targetName() {
        return this.getFieldName();
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

